package gov.va.med.mhv.admin.web.validator;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

@FacesValidator(value = "userSearchIPAValidator")
public class UserSearchIPAValidator implements Validator {

	private static final Pattern pattern = Pattern.compile("^[A-Za-z][0-9][0-9][0-9][0-9]$");
	/*
	 * private static final Pattern emailPattern =
	 * Pattern.compile("^[_A-Za-z0-9-]+(\\." +
	 * "[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*" +
	 * "(\\.[A-Za-z]{2,})$");
	 */
	private static final Pattern[] patternssn;

	static {
		patternssn = new Pattern[] { Pattern.compile("^[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]$"),
				Pattern.compile("^[0-9][0-9][0-9]-[0-9][0-9]-[0-9][0-9][0-9][0-9]$") };
	}

	@Override
	public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {

		String firstPlusFour = null;
		String ssnThree = null;
		String ssnTwo = null;
		String ssnFour = null;
		String firstName = null;
		String middleName = null;
		String lastName = null;
		Date birthDate = null;
		String mhvId = null;
		String email = null;
		Boolean ipaStatusMatched = null;
		Boolean ipaStatusUnmatched = null;
		Boolean ipaStatusCorrelated = null;
		Boolean ipaStatusUncorrelated = null;
		Boolean ipaStatusPendingCorrelation = null;
		Boolean ipaStatusPendingUncorrelated = null;
		Boolean ipaStatusFailedCorrelation = null;
		Boolean ipaStatusFailedUncorrelation = null;
		Boolean ipaStatusCorrelationInvalid = null;
		Boolean ipaStatusAuthenticated = null;
		Boolean ipaStatusPrerequisitesComplete = null;
		Boolean ipaStatusInProcess = null;
		Boolean ipaStatusUnauthenticated = null;
		Boolean ipaStatusPendingDataMismatch = null;
		Boolean ipaStatusPendingUnauthentication = null;

		Matcher matcher = null;

		Date authDateRangeFrom = null;
		Date authDateRangeTo = null;
		String toDate = null;
		String fromDate = null;
		String authenticationFacility = null;
		String treatingFacility = null;

		HtmlInputText firstPlusFourValue = (HtmlInputText) component.getAttributes().get("firstPlusFour");
		HtmlInputText ssnThreeValue = (HtmlInputText) component.getAttributes().get("ssnThree");
		HtmlInputText ssnTwoValue = (HtmlInputText) component.getAttributes().get("ssnTwo");
		HtmlInputText ssnFourValue = (HtmlInputText) component.getAttributes().get("ssnFour");
		HtmlInputText firstNameValue = (HtmlInputText) component.getAttributes().get("firstName");
		HtmlInputText middleNameValue = (HtmlInputText) component.getAttributes().get("middleName");
		HtmlInputText lastNameValue = (HtmlInputText) component.getAttributes().get("lastName");

		UIInput birthDateValue = (UIInput) component.getAttributes().get("birthDate");

		HtmlInputText mhvIdValue = (HtmlInputText) component.getAttributes().get("mhvId");
		HtmlInputText emailValue = (HtmlInputText) component.getAttributes().get("email");

		HtmlSelectBooleanCheckbox ipaStatusMatchedValue = (HtmlSelectBooleanCheckbox) component.getAttributes()
				.get("ipaStatusMatched");
		HtmlSelectBooleanCheckbox ipaStatusUnmatchedValue = (HtmlSelectBooleanCheckbox) component.getAttributes()
				.get("ipaStatusUnmatched");
		HtmlSelectBooleanCheckbox ipaStatusCorrelatedValue = (HtmlSelectBooleanCheckbox) component.getAttributes()
				.get("ipaStatusCorrelated");
		HtmlSelectBooleanCheckbox ipaStatusUncorrelatedValue = (HtmlSelectBooleanCheckbox) component.getAttributes()
				.get("ipaStatusUncorrelated");
		HtmlSelectBooleanCheckbox ipaStatusPendingCorrelationValue = (HtmlSelectBooleanCheckbox) component
				.getAttributes().get("ipaStatusPendingCorrelation");
		HtmlSelectBooleanCheckbox ipaStatusPendingUncorrelatedValue = (HtmlSelectBooleanCheckbox) component
				.getAttributes().get("ipaStatusPendingUncorrelated");
		HtmlSelectBooleanCheckbox ipaStatusFailedCorrelationValue = (HtmlSelectBooleanCheckbox) component
				.getAttributes().get("ipaStatusFailedCorrelation");
		HtmlSelectBooleanCheckbox ipaStatusFailedUncorrelationValue = (HtmlSelectBooleanCheckbox) component
				.getAttributes().get("ipaStatusFailedUncorrelation");
		HtmlSelectBooleanCheckbox ipaStatusCorrelationInvalidValue = (HtmlSelectBooleanCheckbox) component
				.getAttributes().get("ipaStatusCorrelationInvalid");
		HtmlSelectBooleanCheckbox ipaStatusAuthenticatedValue = (HtmlSelectBooleanCheckbox) component.getAttributes()
				.get("ipaStatusAuthenticated");
		HtmlSelectBooleanCheckbox ipaStatusPrerequisitesCompleteValue = (HtmlSelectBooleanCheckbox) component
				.getAttributes().get("ipaStatusPrerequisitesComplete");
		HtmlSelectBooleanCheckbox ipaStatusInProcessValue = (HtmlSelectBooleanCheckbox) component.getAttributes()
				.get("ipaStatusInProcess");
		HtmlSelectBooleanCheckbox ipaStatusUnauthenticatedValue = (HtmlSelectBooleanCheckbox) component.getAttributes()
				.get("ipaStatusUnauthenticated");
		HtmlSelectBooleanCheckbox ipaStatusPendingDataMismatchValue = (HtmlSelectBooleanCheckbox) component
				.getAttributes().get("ipaStatusPendingDataMismatch");
		HtmlSelectBooleanCheckbox ipaStatusPendingUnauthenticationValue = (HtmlSelectBooleanCheckbox) component
				.getAttributes().get("ipaStatusPendingUnauthentication");

		UIInput authDateRangeFromValue = (UIInput) component.getAttributes().get("authDateRangeFrom");
		UIInput authDateRangeToValue = (UIInput) component.getAttributes().get("authDateRangeTo");

		HtmlSelectOneMenu authenticationFacilityValue = (HtmlSelectOneMenu) component.getAttributes()
				.get("authenticationFacility");
		HtmlSelectOneMenu treatingFacilityValue = (HtmlSelectOneMenu) component.getAttributes().get("treatingFacility");

		if (firstPlusFourValue != null && firstPlusFourValue.getValue() != null) {
			firstPlusFour = (String) firstPlusFourValue.getValue();
		}

		if (ssnThreeValue != null && ssnThreeValue.getValue() != null) {
			ssnThree = (String) ssnThreeValue.getValue();
		}

		if (ssnTwoValue != null && ssnTwoValue.getValue() != null) {
			ssnTwo = (String) ssnTwoValue.getValue();
		}

		if (ssnFourValue != null && ssnFourValue.getValue() != null) {
			ssnFour = (String) ssnFourValue.getValue();
		}

		if (firstNameValue != null && firstNameValue.getValue() != null) {
			firstName = (String) firstNameValue.getValue();
		}

		if (middleNameValue != null && middleNameValue.getValue() != null) {
			middleName = (String) middleNameValue.getValue();
		}

		if (lastNameValue != null && lastNameValue.getValue() != null) {
			lastName = (String) lastNameValue.getValue();
		}

		if (birthDateValue != null && birthDateValue.getValue() != null) {
			birthDate = (Date) birthDateValue.getValue();
		}

		if (mhvIdValue != null && mhvIdValue.getValue() != null) {
			mhvId = (String) mhvIdValue.getValue();
		}

		if (emailValue != null && emailValue.getValue() != null) {
			email = (String) emailValue.getValue();
		}

		if (ipaStatusMatchedValue != null && ipaStatusMatchedValue.getValue() != null) {
			ipaStatusMatched = (Boolean) ipaStatusMatchedValue.getValue();
		}

		if (ipaStatusUnmatchedValue != null && ipaStatusUnmatchedValue.getValue() != null) {
			ipaStatusUnmatched = (Boolean) ipaStatusUnmatchedValue.getValue();
		}

		if (ipaStatusCorrelatedValue != null && ipaStatusCorrelatedValue.getValue() != null) {
			ipaStatusCorrelated = (Boolean) ipaStatusCorrelatedValue.getValue();
		}

		if (ipaStatusUncorrelatedValue != null && ipaStatusUncorrelatedValue.getValue() != null) {
			ipaStatusUncorrelated = (Boolean) ipaStatusUncorrelatedValue.getValue();
		}

		if (ipaStatusPendingCorrelationValue != null && ipaStatusPendingCorrelationValue.getValue() != null) {
			ipaStatusPendingCorrelation = (Boolean) ipaStatusPendingCorrelationValue.getValue();
		}

		if (ipaStatusPendingUncorrelatedValue != null && ipaStatusPendingUncorrelatedValue.getValue() != null) {
			ipaStatusPendingUncorrelated = (Boolean) ipaStatusPendingUncorrelatedValue.getValue();
		}

		if (ipaStatusFailedCorrelationValue != null && ipaStatusFailedCorrelationValue.getValue() != null) {
			ipaStatusFailedCorrelation = (Boolean) ipaStatusFailedCorrelationValue.getValue();
		}

		if (ipaStatusFailedUncorrelationValue != null && ipaStatusFailedUncorrelationValue.getValue() != null) {
			ipaStatusFailedUncorrelation = (Boolean) ipaStatusFailedUncorrelationValue.getValue();
		}

		if (ipaStatusCorrelationInvalidValue != null && ipaStatusCorrelationInvalidValue.getValue() != null) {
			ipaStatusCorrelationInvalid = (Boolean) ipaStatusCorrelationInvalidValue.getValue();
		}

		if (ipaStatusAuthenticatedValue != null && ipaStatusAuthenticatedValue.getValue() != null) {
			ipaStatusAuthenticated = (Boolean) ipaStatusAuthenticatedValue.getValue();
		}

		if (ipaStatusPrerequisitesCompleteValue != null && ipaStatusPrerequisitesCompleteValue.getValue() != null) {
			ipaStatusPrerequisitesComplete = (Boolean) ipaStatusPrerequisitesCompleteValue.getValue();
		}

		if (ipaStatusInProcessValue != null && ipaStatusInProcessValue.getValue() != null) {
			ipaStatusInProcess = (Boolean) ipaStatusInProcessValue.getValue();
		}

		if (ipaStatusUnauthenticatedValue != null && ipaStatusUnauthenticatedValue.getValue() != null) {
			ipaStatusUnauthenticated = (Boolean) ipaStatusUnauthenticatedValue.getValue();
		}

		if (ipaStatusPendingDataMismatchValue != null && ipaStatusPendingDataMismatchValue.getValue() != null) {
			ipaStatusPendingDataMismatch = (Boolean) ipaStatusPendingDataMismatchValue.getValue();
		}

		if (ipaStatusPendingUnauthenticationValue != null && ipaStatusPendingUnauthenticationValue.getValue() != null) {
			ipaStatusPendingUnauthentication = (Boolean) ipaStatusPendingUnauthenticationValue.getValue();
		}

		if (authDateRangeFromValue != null && authDateRangeFromValue.getValue() != null) {
			authDateRangeFrom = (Date) authDateRangeFromValue.getValue();
			fromDate = dateToString(authDateRangeFrom, "yyyyMMdd");
		}

		if (authDateRangeToValue != null && authDateRangeToValue.getValue() != null) {
			authDateRangeTo = (Date) authDateRangeToValue.getValue();
			toDate = dateToString(authDateRangeTo, "yyyyMMdd");
		}

		if (authenticationFacilityValue != null && authenticationFacilityValue.getValue() != null) {
			authenticationFacility = (String) authenticationFacilityValue.getValue();
		}

		if (treatingFacilityValue != null && treatingFacilityValue.getValue() != null) {
			treatingFacility = (String) treatingFacilityValue.getValue();
		}

		Calendar cal = Calendar.getInstance();
		String currentDate = dateToString(cal.getTime(), "yyyyMMdd");

		// fail validation if certain conditions are not met
		if ((firstPlusFour == null || firstPlusFour.isEmpty()) && (ssnThree == null || ssnThree.isEmpty())
				&& (ssnTwo == null || ssnTwo.isEmpty()) && (ssnFour == null || ssnFour.isEmpty())
				&& (firstName == null || firstName.isEmpty()) && (middleName == null || middleName.isEmpty())
				&& (lastName == null || lastName.isEmpty()) && (birthDate == null) && (mhvId == null || mhvId.isEmpty())
				&& (email == null || email.isEmpty()) && (ipaStatusMatched == null || !ipaStatusMatched)
				&& (ipaStatusUnmatched == null || !ipaStatusUnmatched)
				&& (ipaStatusCorrelated == null || !ipaStatusCorrelated)
				&& (ipaStatusUncorrelated == null || !ipaStatusUncorrelated)
				&& (ipaStatusPendingCorrelation == null || !ipaStatusPendingCorrelation)
				&& (ipaStatusPendingUncorrelated == null || !ipaStatusPendingUncorrelated)
				&& (ipaStatusFailedCorrelation == null || !ipaStatusFailedCorrelation)
				&& (ipaStatusFailedUncorrelation == null || !ipaStatusFailedUncorrelation)
				&& (ipaStatusCorrelationInvalid == null || !ipaStatusCorrelationInvalid)
				&& (ipaStatusAuthenticated == null || !ipaStatusAuthenticated)
				&& (ipaStatusPrerequisitesComplete == null || !ipaStatusPrerequisitesComplete)
				&& (ipaStatusInProcess == null || !ipaStatusInProcess)
				&& (ipaStatusUnauthenticated == null || !ipaStatusUnauthenticated)
				&& (ipaStatusPendingDataMismatch == null || !ipaStatusPendingDataMismatch)
				&& (ipaStatusPendingUnauthentication == null || !ipaStatusPendingUnauthentication)
				&& (authDateRangeFrom == null) && (authDateRangeTo == null)
				&& (authenticationFacility == null || authenticationFacility.isEmpty())
				&& (treatingFacility == null || treatingFacility.isEmpty())) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR,
					bundle.getString("userSearchFormCriteriaErrorHeader"), ""));
		}

		if (null != lastName && !lastName.isEmpty() && lastName.trim().length() < 2) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(
					new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("lastNameError"), ""));
		}

		if (null != firstName && !firstName.isEmpty() && firstName.trim().length() < 2) {
			ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
					FacesContext.getCurrentInstance().getViewRoot().getLocale());
			throw new ValidatorException(
					new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("firstNameError"), ""));
		}

		if (firstPlusFour != null) {
			Matcher m = pattern.matcher(firstPlusFour);
			if (!m.matches()) {
				ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
						FacesContext.getCurrentInstance().getViewRoot().getLocale());
				throw new ValidatorException(
						new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("invalidForstPlusFourSum"), ""));
			}
		}

		/*
		 * if (email != null) { Matcher m = emailPattern.matcher(email); if
		 * (!m.matches()) { ResourceBundle bundle =
		 * ResourceBundle.getBundle("labels.messages",
		 * FacesContext.getCurrentInstance().getViewRoot().getLocale()); throw
		 * new ValidatorException( new FacesMessage(FacesMessage.SEVERITY_ERROR,
		 * bundle.getString("invalidEmail"), "")); } }
		 */

		if (authDateRangeFrom != null && authDateRangeTo != null) {
			if (Integer.parseInt(fromDate) > Integer.parseInt(currentDate)
					|| Integer.parseInt(toDate) > Integer.parseInt(currentDate)) {
				ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
						FacesContext.getCurrentInstance().getViewRoot().getLocale());
				throw new ValidatorException(
						new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("invalidFutureDate"), ""));
			}
		}

		if (authDateRangeFrom != null && authDateRangeTo != null) {
			if (Integer.parseInt(fromDate) > Integer.parseInt(toDate)) {
				ResourceBundle bundle = ResourceBundle.getBundle("labels.messages",
						FacesContext.getCurrentInstance().getViewRoot().getLocale());
				throw new ValidatorException(
						new FacesMessage(FacesMessage.SEVERITY_ERROR, bundle.getString("errorFromGrtSummary"), ""));
			}
		}

		String ssn = "";

		if (ssnThree != null || ssnTwo != null || ssnFour != null) {
			if (ssnThree != null && ssnTwo != null && ssnFour != null) {
				ssn = ssnThree + "-" + ssnTwo + "-" + ssnFour;
			} else if (ssnThree != null && ssnTwo != null && ssnFour == null) {
				ssn = ssnThree + "-" + ssnTwo;
			} else if (ssnThree == null && ssnTwo != null && ssnFour != null) {
				ssn = ssnTwo + "-" + ssnFour;
			} else if (ssnThree == null && ssnTwo == null && ssnFour != null) {
				ssn = ssnFour;
			} else if (ssnThree == null && ssnTwo != null && ssnFour == null) {
				ssn = ssnTwo;
			} else if (ssnThree != null && ssnTwo == null && ssnFour == null) {
				ssn = ssnThree;
			} else if (ssnThree != null && ssnTwo == null && ssnFour != null) {
				ssn = ssnThree + "-" + ssnFour;

			}

			String expression = "^\\d{3}[- ]?\\d{2}[- ]?\\d{4}$";
			Pattern patternSsn = Pattern.compile(expression);
			matcher = patternSsn.matcher(ssn);
			if (!matcher.matches()) {
				String tempSSn = "'" + ssn + "' is not a valid Social Security Number.";
				throw new ValidatorException(new FacesMessage(FacesMessage.SEVERITY_ERROR, tempSSn, ""));
			}

		}

	}

	private static String dateToString(Date date, String format) {
		String stringDate = "";
		try {
			if (date != null) {
				SimpleDateFormat sdf = new SimpleDateFormat(format);
				stringDate = sdf.format(date);
			}
		} catch (Exception e) {
			throw new RuntimeException("Invalid Date format", e);
		}
		return stringDate;
	}

}
